/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.enchantments;

import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnchantmentTunneling
extends Enchantment {
    public EnchantmentTunneling() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("tunneling");
        this.func_77322_b("mujmajnkraftsbettersurvival.tunneling");
    }

    public static void mineManyBlocks(EntityPlayer miner, IBlockState state, BlockPos pos) {
        World world = miner.func_130014_f_();
        ItemStack stack = miner.func_184614_ca();
        int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.tunneling, (ItemStack)miner.func_184614_ca());
        if (l > 0 && EnchantmentTunneling.canMineEffectively(miner, state, pos)) {
            int dir;
            EnumFacing facing = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)miner).func_176734_d();
            switch (facing.func_176610_l()) {
                case "west": {
                    dir = 1;
                    break;
                }
                case "east": {
                    dir = 2;
                    break;
                }
                case "down": {
                    dir = 3;
                    break;
                }
                case "up": {
                    dir = 4;
                    break;
                }
                case "south": {
                    dir = 5;
                    break;
                }
                case "north": {
                    dir = 6;
                    break;
                }
                default: {
                    dir = 0;
                }
            }
            if (dir != 0) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("tunnelCooldown", true);
                for (int x = -l; x < l + 1; ++x) {
                    if ((dir == 1 || dir == 2) && x != 0) continue;
                    for (int y = -l; y < l + 1; ++y) {
                        if ((dir == 3 || dir == 4) && y != 0) continue;
                        for (int z = -l; z < l + 1; ++z) {
                            BlockPos pos1;
                            if ((dir == 5 || dir == 6) && z != 0 || !(Math.sqrt(x * x + y * y + z * z) <= (double)(((float)l + 1.0f) / 2.0f)) || x == 0 && y == 0 && z == 0 || !EnchantmentTunneling.canMineEffectively(miner, world.func_180495_p(pos1 = pos.func_177982_a(x, y, z)), pos1)) continue;
                            ((EntityPlayerMP)miner).field_71134_c.func_180237_b(pos1);
                        }
                    }
                }
                stack.func_77978_p().func_74757_a("tunnelCooldown", false);
            }
        }
    }

    static boolean canMineEffectively(EntityPlayer player, IBlockState state, BlockPos pos) {
        ItemStack stack = player.func_184614_ca();
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return false;
        }
        if (ForgeConfigHandler.enchantments.preventTunnelingTileEntities && player.field_70170_p.func_175625_s(pos) != null) {
            return false;
        }
        for (String type : stack.func_77973_b().getToolClasses(player.func_184614_ca())) {
            if (!block.isToolEffective(type, state) || block.getHarvestLevel(state) > stack.func_77973_b().getHarvestLevel(player.func_184614_ca(), type, player, state)) continue;
            return true;
        }
        return false;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 25 + (enchantmentLevel - 1) * 15;
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77325_b() {
        return ForgeConfigHandler.enchantments.tunnelingLevel;
    }

    public boolean func_185261_e() {
        return ForgeConfigHandler.enchantments.tunnelingTreasure;
    }

    public boolean isAllowedOnBooks() {
        return ForgeConfigHandler.enchantments.tunnelingLevel != 0;
    }
}

